#!/bin/bash

#SBATCH --partition=gpu_h100    # Specify the partition (e.g., 'gpu')
#SBATCH --gpus=1                # Request 4 GPUs
#SBATCH --job-name=ARC     # Name of the job
#SBATCH --ntasks=1                # Number of tasks
#SBATCH --cpus-per-task=8        # Number of CPU cores per task
#SBATCH --time=2:00:00           # Set time limit for the job (4 hours)
#SBATCH --output=outputs/slurm_output_%A.out  # Output file name, %A for job ID
#SBATCH --error=outputs/slurm_error_%A.err

module purge
module load 2022                  # Load necessary environment modules
# module load Anaconda3/2022.05    # Uncomment this if you need to load a specific Anaconda module

# Source the bash profile to load Conda properly
source ~/.bashrc                  # Adjust this to your shell profile (e.g., .bash_profile or .bashrc)

# Activate your Conda environment
conda activate ditto_env

# Run your Python script
source experiment_scripts/evaluation_lpn.sh